private _Object = _this;
private _ClosestPullVehicle = objNull;
private _ClosestDistance = 1000000;
private _dt = 0.1;
private _CurrentDistance = 0;
private _Continue = true;
private _InitialFuel = 0;
private _FoundIndex = 0;
private _MovementDirection = [0,0,0];
private _CurrentObjectPosition = [0,0,0];
private _PreviusTime = 0;
private _dt_real = 0;
private _NewObjectPosition = [0,0,0];
private _CurrentRopeLength = 0;
private _VelocityMultiplier = 0;
private _LastRecordedPosition = [0,0,0];
private _Drift = [0,0,0];
private _FrictionCorrection = [0,0,0];

//LastHedge = _Object;

if(isServer)then
{
	{
		_CurrentDistance = _Object distance _x;
		if(_CurrentDistance < _ClosestDistance && !(_x in Winch_VehiclesInUse) && ((getDammage _x) < 1))then
		{
			_ClosestDistance = _CurrentDistance;
			_ClosestPullVehicle = _x;
		};
	} forEach Winch_VehiclesWithWinch;

	if(!(isNull _ClosestPullVehicle) && (_ClosestDistance < WinchMaximumDistance))then
	{
		Winch_VehiclesInUse = Winch_VehiclesInUse + [_ClosestPullVehicle];
		WincCurrentlyDragedObjects = WincCurrentlyDragedObjects + [_Object];
		publicVariable "WincCurrentlyDragedObjects";
		[-1, {
			[_this select 0, 0, [], Winch_CancelAction] call ace_interact_menu_fnc_addActionToObject;
			[_this select 1, 0, [], Winch_CancelAction] call ace_interact_menu_fnc_addActionToObject;
		}, [_Object,_ClosestPullVehicle]] call CBA_fnc_globalExecute;

		_InitialFuel = fuel _ClosestPullVehicle;
		if(local _ClosestPullVehicle)then
		{
			_ClosestPullVehicle setFuel 0;
		}
		else
		{
			[-1, {
					if(local _this)then
					{
						_this setFuel 0;
					};
				}, _ClosestPullVehicle] call CBA_fnc_globalExecute;
		};
		_CurrentRopeLength = (_Object distance _ClosestPullVehicle);
		_LastRecordedPosition = getpos _Object;
		_PreviusTime = time;
		while {_Continue}do
		{
			sleep _dt;
			_dt_real = time - _PreviusTime;
			_PreviusTime = time;
			_MovementDirection = (getPosASL _ClosestPullVehicle) vectorDiff (getPosASL _Object);
			_MovementDirection = vectorNormalized  _MovementDirection;
			_MovementDirection = _MovementDirection vectorMultiply WinchWindingSpeed;
			_MovementDirection set [2,0];//Make movement 2D
			_CurrentObjectPosition = getPos _Object;
			_NewObjectPosition = _CurrentObjectPosition vectorAdd (_MovementDirection vectorMultiply _dt_real);
			_VelocityMultiplier = ((_Object distance _ClosestPullVehicle)/_CurrentRopeLength)*WinchRopteStiffnes;
			_FrictionCorrection = _Drift vectorMultiply ((-1)*WinchFrictionCoef);
			_FrictionCorrection set [2,0];
			_LastRecordedPosition = getpos _Object;
			_Object setpos (_NewObjectPosition vectorAdd (_FrictionCorrection vectorMultiply _dt_real));
			_Drift = (_Drift vectorMultiply 0.9) vectorAdd (((getPos _Object) vectorDiff _LastRecordedPosition) vectorMultiply (0.1/_dt_real));
			_Object setVelocity ((_MovementDirection vectorMultiply _VelocityMultiplier) vectorAdd _FrictionCorrection);
			_CurrentRopeLength = _CurrentRopeLength - WinchWindingSpeed*_dt_real;
			_CurrentRopeLength = 0.5 max _CurrentRopeLength;
			_Continue = ((_Object distance _ClosestPullVehicle) > WinchMinimalAllowedDistance) && !(_ClosestPullVehicle in WinchCancelRequest) && !(_Object in WinchCancelRequest) && (getDammage _ClosestPullVehicle < 1);
		};

		_FoundIndex = WincCurrentlyDragedObjects find _Object;
		while{_FoundIndex >= 0}do
		{
			WincCurrentlyDragedObjects deleteAt _FoundIndex;
			_FoundIndex = WincCurrentlyDragedObjects find _Object;
		};
		publicVariable "WincCurrentlyDragedObjects";

		[-1, {
			[_this select 0,0,["Cancel"]] call ace_interact_menu_fnc_removeActionFromObject;
			[_this select 1,0,["Cancel"]] call ace_interact_menu_fnc_removeActionFromObject;
		}, [_Object,_ClosestPullVehicle]] call CBA_fnc_globalExecute;

		if(local _ClosestPullVehicle)then
		{
			_ClosestPullVehicle setFuel _InitialFuel;
		}
		else
		{
			[-1, {
					if(local (_this select 0))then
					{
						 (_this select 0) setFuel (_this select 1);
					};
				}, [_ClosestPullVehicle,_InitialFuel]] call CBA_fnc_globalExecute;
		};

		_FoundIndex = WinchCancelRequest find _Object;
		while{_FoundIndex >= 0}do
		{
			WinchCancelRequest deleteAt _FoundIndex;
			_FoundIndex = WinchCancelRequest find _Object;
		};

		_FoundIndex = WinchCancelRequest find _ClosestPullVehicle;
		while{_FoundIndex >= 0}do
		{
			WinchCancelRequest deleteAt _FoundIndex;
			_FoundIndex = WinchCancelRequest find _Object;
		};

		_FoundIndex = Winch_VehiclesInUse find _ClosestPullVehicle;
		if(_FoundIndex >= 0)then
		{
			Winch_VehiclesInUse deleteAt _FoundIndex;
		};
	}
	else
	{
		hint "No vehicle with pulling device in reach.";
	};
	[-1, {
		[_this, 0, [], Winch_DragAction] call ace_interact_menu_fnc_addActionToObject;
	}, _Object] call CBA_fnc_globalExecute;
};


