private _FunctionDirectory = "scripts\HelmetCam\";

HelmetCam_DeleteLinksWithoutUnit =
{
	private _i = 0;
	private _CurrentLink = [];
	while {_i < count HelmetCam_Links}do
	{
		_CurrentLink = HelmetCam_Links select _i;
		if(isNull (_CurrentLink select 0))then
		{
			deleteVehicle (_CurrentLink select 2);
			(_CurrentLink select 1) setObjectTextureGlobal [0, "#(argb,512,512,1)r2t(no_feed,1)"];
			HelmetCam_Links deleteAt _i;
		}
		else
		{
			_i = _i + 1;
		};
	};
	publicVariable "HelmetCam_Links";
};

HelmetCam_RefreshNVG =
{
	private _i = 0;
	private _LinksArray = [];
	private _CurrentLink = [];
	if(isServer)then
	{
		_LinksArray = HelmetCam_Links;
	}
	else
	{
		_LinksArray = HelmetCam_LocalLinks;
	};
	while {_i < count _LinksArray}do
	{
		_CurrentLink = _LinksArray select _i;
		_CurretMode = currentVisionMode(_CurrentLink select 0);
		(_CurrentLink select 3) setPiPEffect [_CurretMode];
		_i = _i + 1;
	};
};

HelmetCam_DeleteLocalLinks =
{
	private _i = 0;
	private _CurrentLink = [];
	while {_i < count HelmetCam_LocalLinks}do
	{
		_CurrentLink = HelmetCam_LocalLinks select _i;
		if(isNull (_CurrentLink select 0))then
		{
			deleteVehicle (_CurrentLink select 2);
			HelmetCam_LocalLinks deleteAt _i;
		}
		else
		{
			_i = _i + 1;
		};
	};
};

HelmetCam_IsThisUnitInLocalLinks =
{
	private _i = 0;
	private _Output = false;
	private _CurrentLinkToBeTested = [];
	while {_i < count HelmetCam_LocalLinks}do
	{
		_CurrentLinkToBeTested = HelmetCam_LocalLinks select _i;
		if((_CurrentLinkToBeTested select 0) == _this)then
		{
			_Output = true;
		};
		_i = _i + 1;
	};
	_Output
};

HelmetCam_CreateMissingLocalCameras =
{
	private _i = 0;
	private _CurrentLink = [];
	private _Screen = objNull;
	private _FeedName = "";
	private _NewLocalCamera = objNull;
	private _UnitReference = objNull;
	private _Exist = false;

	while {_i < count HelmetCam_Links}do
	{
		_CurrentLink = HelmetCam_Links select _i;
		_UnitReference = (_CurrentLink select 0);
		_Exist = _UnitReference call HelmetCam_IsThisUnitInLocalLinks;
		if(!_Exist)then
		{
			_Screen = _CurrentLink select 1;
			_FeedName = _CurrentLink select 3;
			_NewLocalCamera = "camera" camCreate (getpos _UnitReference);
			_NewLocalCamera attachTo [_UnitReference,[0,0,0],"head"];
			_Screen setObjectTextureGlobal [0, "#(argb,512,512,1)r2t("+_FeedName+",1)"];
			_NewLocalCamera cameraEffect ["Internal", "Back", _FeedName];
			HelmetCam_LocalLinks = HelmetCam_LocalLinks + [[_UnitReference,_Screen,_NewLocalCamera,_FeedName]];
		};
		_i = _i + 1;
	};
};


Helmet_CamSolveCameraInVehicle =
{
	private _i = 0;
	private _LinksArray = [];
	private _CurrentLink = [];
	private _Unit = objNull;
	private _Cam = objNull;
	private _Vehicle = objNull;
	private _Terrain = 0;
	private _EyePosition = [];
	private _LocalEyePos = [];
	if(isServer)then
	{
		_LinksArray = HelmetCam_Links;
	}
	else
	{
		_LinksArray = HelmetCam_LocalLinks;
	};
	while {_i < count _LinksArray}do
	{
		_CurrentLink = _LinksArray select _i;
		_Unit = _CurrentLink select 0;
		_Cam = _CurrentLink select 2;
		if((vehicle _Unit) == _Unit)then
		{//Unit is outside
			if((attachedTo _Cam) != _Unit)then
			{//Camera is not attached to unit
				_Cam attachTo [_Unit,[0,0,0],"head"];
			};
		}
		else
		{//Unit is in vehicle
			_Vehicle = vehicle _Unit;
			_Terrain = getTerrainHeightASL (getpos _Unit);
			_EyePosition = eyePos _Unit;
			if(((_EyePosition distance (getposASL _Cam)) > 0.2) || ((attachedTo _Cam) != _Vehicle))then
			{
				_EyePosition set [2,(_EyePosition select 2) - _Terrain];//Eye position above terrain
				_LocalEyePos = _Vehicle worldToModel _EyePosition;
				_Cam attachTo [_Vehicle,_LocalEyePos];
			};
		};
		_i = _i + 1;
	};

};


if(isServer)then
{
	HelmetCam_Links = [];//Unit,screen,camera,link name
	HelmetCam_StatusCheckScript = [] spawn compileFinal preprocessFile  (_FunctionDirectory + "StatusCheckScript.sqf");
}
else
{
	HelmetCam_LocalLinks = [];//Unit,Screen,Camera,link name
	HelmetCam_StatusCheckScript = [] spawn compileFinal preprocessFile (_FunctionDirectory + "StatusCheckScript_client.sqf");
};
